/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.filesystem.Glob;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;

public class RecentUrisGUI
extends JPanel {
    String selectedURI = null;
    boolean empty = false;
    DefaultTreeModel deftree = new DefaultTreeModel(new DefaultMutableTreeNode(""));
    MyTreeModel theModel = null;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    private String filter;
    private JScrollPane jScrollPane1;
    private JTree jTree1;

    public RecentUrisGUI() {
        this.initComponents();
        this.deftree.insertNodeInto(new DefaultMutableTreeNode("moment..."), (DefaultMutableTreeNode)this.deftree.getRoot(), 0);
        this.jTree1.setModel(this.deftree);
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object o = e.getPath().getLastPathComponent();
                if (o instanceof String[]) {
                    String[] pp = (String[])o;
                    RecentUrisGUI.this.selectedURI = pp[1];
                }
            }
        });
    }

    public String getSelectedURI() {
        return this.selectedURI;
    }

    public static void main(String[] args) {
        RecentUrisGUI t = new RecentUrisGUI();
        t.setFilter("");
        int i = JOptionPane.showConfirmDialog(null, t);
        if (i == 0) {
            System.err.println(t.getSelectedURI());
        }
    }

    public void setFilter(String filter) {
        this.jTree1.setModel(this.deftree);
        this.jTree1.setCellRenderer(new DefaultTreeCellRenderer());
        this.jTree1.repaint();
        this.filter = filter;
        DasProgressPanel label = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"reading history");
        new Thread(this.getUpdateRunnable((ProgressMonitor)label), "updateRecentUris").start();
    }

    private Runnable getUpdateRunnable(final ProgressMonitor mon) {
        return new Runnable(){

            @Override
            public void run() {
                RecentUrisGUI.this.update(mon);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ProgressMonitor mon) {
        MyTreeModel ltheModel = new MyTreeModel(mon);
        RecentUrisGUI recentUrisGUI = this;
        synchronized (recentUrisGUI) {
            this.theModel = ltheModel;
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object child;
                RecentUrisGUI recentUrisGUI = RecentUrisGUI.this;
                synchronized (recentUrisGUI) {
                    RecentUrisGUI.this.jTree1.setModel(RecentUrisGUI.this.theModel);
                }
                RecentUrisGUI.this.jTree1.setCellRenderer(new MyCellRenderer());
                Object r = RecentUrisGUI.this.jTree1.getModel().getRoot();
                int c = 0;
                int SHOW_URIS = 30;
                TreeModel jt = RecentUrisGUI.this.jTree1.getModel();
                for (int i = 0; i < jt.getChildCount(jt.getRoot()) && c < 30; c += jt.getChildCount(child), ++i) {
                    child = jt.getChild(r, i);
                    RecentUrisGUI.this.jTree1.expandPath(new TreePath(new Object[]{r, child}));
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected JTree getTree() {
        return this.jTree1;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jTree1.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.jTree1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    private final class MyTreeModel
    implements TreeModel {
        private final Object root = new Object();
        private TreeMap<Datum, String[]> uris;
        private DatumRange[] list;
        private boolean[] skip;

        MyTreeModel(ProgressMonitor mon) {
            this.update(mon);
        }

        private String nameFor(DatumRange dr) {
            if (dr == this.list[0]) {
                return "today";
            }
            if (dr == this.list[1]) {
                return "yesterday";
            }
            if (dr == this.list[2]) {
                return "previous week";
            }
            return dr.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void update(ProgressMonitor mon) {
            boolean ok;
            if (EventQueue.isDispatchThread()) {
                throw new IllegalStateException("should not be called from event queue");
            }
            Datum tz = Units.milliseconds.createDatum(Calendar.getInstance().getTimeZone().getRawOffset());
            Datum now = TimeUtil.now().add(tz);
            this.list = new DatumRange[8];
            this.list[0] = new DatumRange(TimeUtil.prevMidnight((Datum)now).subtract(tz), TimeUtil.nextMidnight((Datum)now).subtract(tz));
            this.list[1] = this.list[0].previous();
            this.list[2] = new DatumRange(TimeUtil.prevWeek((Datum)this.list[1].min()), this.list[1].min());
            this.list[3] = new DatumRange(TimeUtil.prev((int)2, (Datum)this.list[2].min()), this.list[2].min());
            this.list[4] = new DatumRange(TimeUtil.prev((int)98, (Datum)this.list[3].min()), this.list[3].min());
            this.list[5] = new DatumRange(TimeUtil.prev((int)98, (Datum)this.list[4].min()), this.list[4].min());
            this.list[6] = new DatumRange(TimeUtil.prev((int)99, (Datum)this.list[5].min()), this.list[5].min());
            this.list[7] = new DatumRange(Datum.create((int)0, (Units)Units.t1970), this.list[6].min());
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "bookmarks/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            this.uris = new TreeMap();
            TimeParser tp = TimeParser.create((String)"$Y-$m-$dT$H:$M:$S.$(subsec;places=3)Z");
            LinkedHashMap<String, String> daysURIs = new LinkedHashMap<String, String>();
            Pattern filtPattern = null;
            String filt = RecentUrisGUI.this.filter;
            if (filt != null && filt.length() == 0) {
                filt = null;
            }
            if (filt != null) {
                filt = filt.toLowerCase();
            }
            if (filt != null) {
                filt = "(?i)" + Glob.getRegex((String)filt);
                filtPattern = Pattern.compile(filt);
            }
            long tzOffsetMs = Calendar.getInstance().getTimeZone().getRawOffset();
            String midnight = tp.format(Units.t1970.createDatum(0).subtract((double)tzOffsetMs, Units.milliseconds), null);
            mon.started();
            try {
                mon.setTaskSize(50000L);
                int iline = 0;
                File f3 = new File(f2, "history.txt");
                if (f3.exists() && f3.canRead()) {
                    Datum tlocal;
                    Scanner scan;
                    try {
                        scan = new Scanner(f3);
                    }
                    catch (FileNotFoundException ex) {
                        throw new IllegalStateException(ex);
                    }
                    while (scan.hasNextLine()) {
                        String line = scan.nextLine();
                        String[] stringArray = line.split("\\s+", 2);
                        mon.setTaskProgress((long)(++iline));
                        mon.setProgressMessage(stringArray[0]);
                        if (stringArray.length < 2) continue;
                        try {
                            String suri = stringArray[1];
                            if (suri.startsWith("file://") && suri.length() > 7 && suri.charAt(7) != '/') {
                                stringArray[1] = suri = "file:/" + suri.substring(7);
                            }
                            if (filtPattern != null && !filtPattern.matcher(stringArray[1]).find()) continue;
                            if (stringArray[0].compareTo(midnight) > 0 || !scan.hasNextLine()) {
                                if (!scan.hasNextLine()) {
                                    daysURIs.remove(stringArray[1]);
                                    daysURIs.put(stringArray[1], stringArray[0]);
                                }
                                tlocal = null;
                                for (Map.Entry ent : daysURIs.entrySet()) {
                                    String uri = (String)ent.getKey();
                                    tlocal = tp.parse((String)ent.getValue()).getTimeDatum().add((double)tzOffsetMs, Units.milliseconds);
                                    this.uris.put(tlocal, new String[]{tp.format(tlocal, null), uri});
                                }
                                daysURIs = new LinkedHashMap();
                                if (tlocal == null) {
                                    tlocal = tp.parse(stringArray[0]).getTimeDatum().add((double)tzOffsetMs, Units.milliseconds);
                                }
                                midnight = tp.format(TimeUtil.nextMidnight((Datum)tlocal).subtract((double)tzOffsetMs, Units.milliseconds), null);
                            }
                            daysURIs.remove(stringArray[1]);
                            daysURIs.put(stringArray[1], stringArray[0]);
                        }
                        catch (ParseException ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                    scan.close();
                    for (Map.Entry entry : daysURIs.entrySet()) {
                        try {
                            String uri = (String)entry.getKey();
                            tlocal = tp.parse((String)entry.getValue()).getTimeDatum().add((double)tzOffsetMs, Units.milliseconds);
                            this.uris.put(tlocal, new String[]{tp.format(tlocal, null), uri});
                        }
                        catch (ParseException ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
                this.skip = new boolean[8];
                int newListLen = this.list.length;
                for (int i = 0; i < this.list.length; ++i) {
                    this.skip[i] = false;
                }
                if (newListLen == 0) {
                    RecentUrisGUI.this.empty = true;
                    newListLen = 1;
                    this.skip[0] = false;
                } else {
                    RecentUrisGUI.this.empty = false;
                }
                DatumRange[] newlist = new DatumRange[newListLen];
                boolean bl = false;
                for (int i = 0; i < this.list.length; ++i) {
                    void var16_24;
                    if (this.skip[i]) continue;
                    newlist[var16_24] = this.list[i];
                    ++var16_24;
                }
                this.list = newlist;
            }
            finally {
                mon.finished();
            }
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.root) {
                if (RecentUrisGUI.this.empty) {
                    return "no items in history";
                }
                return this.list[index];
            }
            if (parent instanceof DatumRange) {
                DatumRange range = (DatumRange)parent;
                SortedMap<Datum, String[]> submap = this.uris.subMap(range.min(), range.max());
                Iterator<String[]> i = submap.values().iterator();
                for (int j = submap.size() - 1; j > index; --j) {
                    i.next();
                }
                return i.next();
            }
            return new IndexOutOfBoundsException("no child at index=" + index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.root) {
                return this.list.length;
            }
            if (parent instanceof DatumRange) {
                DatumRange range = (DatumRange)parent;
                SortedMap<Datum, String[]> submap = this.uris.subMap(range.min(), range.max());
                return submap.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof String[] || this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            for (int i = 0; i < this.getChildCount(parent); ++i) {
                if (this.getChild(parent, i) != child) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String tooltip = null;
            if (value instanceof String[]) {
                tooltip = ((String[])value)[0];
                value = ((String[])value)[1];
            } else if (value instanceof DatumRange) {
                MyTreeModel ltheModel;
                tooltip = ((DatumRange)value).toString();
                int count = tree.getModel().getChildCount(value);
                RecentUrisGUI recentUrisGUI = RecentUrisGUI.this;
                synchronized (recentUrisGUI) {
                    ltheModel = RecentUrisGUI.this.theModel;
                }
                value = String.format("%s (%d)", ltheModel.nameFor((DatumRange)value), count);
            }
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setToolTipText(tooltip);
            }
            return c;
        }
    }
}

